/*
	Author: Public Domain, with some modifications
	Script Source URI: http://techpatterns.com/downloads/javascript_cookies.php
	Version 1.0.0
	Last Update: 30 May 2004
	
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
*/

/*
	getCookie
	
	Get a cookie's value. If the cookie does not exist, null is returned.
*/

function getCookie(name)
{
	var start = document.cookie.indexOf(name + "=");
	var len = start + name.length + 1;
	
	if ((!start) && (name != document.cookie.substring(0, name.length)))
		return null;
	
	if (start == -1)
		return null;
	
	var end = document.cookie.indexOf(";", len);
	
	if (end == -1)
		end = document.cookie.length;
	
	return unescape(document.cookie.substring(len, end));
}


/*
	setCookie
	
	Only the first 2 parameters are required, the cookie name and the cookie
	value. Cookie time is in milliseconds, so the below expires will make the 
	number you pass in the Set_Cookie function call the number of days the cookie
	lasts, if you want it to be hours or minutes, just get rid of 24 and 60.
	
	Generally you don't need to worry about domain, path or secure for most applications
	so unless you need that, leave those parameters blank in the function call.
*/

function setCookie(name, value, expires, path, domain, secure)
{
	// Set the time, it's in milliseconds
	var today = new Date();
	today.setTime(today.getTime());
	
	// If the expires variable is set, make the correct expires time, the
	// current script below will set it for x number of days, to make it
	// for hours, delete * 24, for minutes, delete * 60 * 24
	if (expires)
		expires = expires * 1000 * 60 * 60 * 24;
	else
		expires = 0;
	
	var expires_date = new Date(today.getTime() + (expires));
	
	if (!value || value == "")
		value = "none";

	document.cookie = name + "=" + escape(value) +
		((expires) ? ";expires=" + expires_date.toGMTString() : "" ) + //expires.toGMTString()
		((path)    ? ";path=" + path : "" ) + 
		((domain)  ? ";domain=" + domain : "" ) +
		((secure)  ? ";secure" : "" );
}


/*
	deleteCookie
	
	Delete a cookie with the given name, path and domain.
*/

function deleteCookie(name, path, domain)
{
	if (getCookie(name))
		document.cookie = name + "=" +
			((path)   ? ";path=" + path : "") +
			((domain) ? ";domain=" + domain : "" ) +
			";expires=Thu, 01-Jan-1970 00:00:01 GMT";
}
